// XISLReturnTag.cpp: CXISLReturnTag NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ib.h"
#include "XISLReturnTag.h"
#include "XISLVar.h"
#include "XISLExchangeTag.h"
#include "XISLDialogTag.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CXISLReturnTag::CXISLReturnTag()
{
	m_nTagType = ID_TAG_RETURN;
	m_nBmpID = IDB_RETURN;

	m_pParentTag = NULL;
}

CXISLReturnTag::~CXISLReturnTag()
{
	InitPtrList();
}

CXISLReturnTag::CXISLReturnTag(const CXISLReturnTag &cpXISL)
{
	m_nTagType = cpXISL.m_nTagType;
	m_strXISL = cpXISL.m_strXISL;
	m_rectBMP = cpXISL.m_rectBMP;
	m_nBmpID = cpXISL.m_nBmpID;
	m_htreeItem = cpXISL.m_htreeItem;
	m_pParentTag = cpXISL.m_pParentTag;
}

CXISLReturnTag& CXISLReturnTag::operator=(const CXISLReturnTag &cpXISL)
{
	if(&cpXISL != this)
	{
		m_nTagType = cpXISL.m_nTagType;
		m_strXISL = cpXISL.m_strXISL;
		m_rectBMP = cpXISL.m_rectBMP;
		m_nBmpID = cpXISL.m_nBmpID;
		m_htreeItem = cpXISL.m_htreeItem;
		m_pParentTag = cpXISL.m_pParentTag;
	}
	return *this;
}

LPCTSTR CXISLReturnTag::GetXISLString()
{
	CString strTemp;
	if(m_NameList.IsEmpty())
		m_strXISL = "<return />\r\n";
	else
	{
		m_strXISL = "<return namelist = \"";
		GetNameList(strTemp);
		m_strXISL += strTemp;
		m_strXISL += "\"/>\r\n";
	}

	return m_strXISL;
}

//BOOL CXISLReturnTag::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
//@\@Fc[Rg[XISL^Oo^
//@FCTreeCtrl *pTree  :o^c[Rg[
//		  HTREEITEM hParent :eڂ̃nh
//ԂlFBOOL@FTRUE@sFFALSE
BOOL CXISLReturnTag::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
{
	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = hParent;

	//c[ɓo^
	tvi.pszText = XISL_TAG_NAME[ID_TAG_RETURN];
	tvi.lParam = (LPARAM)this;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	hParent = pTree->InsertItem(&tvs);
	m_htreeItem = hParent;

	return TRUE;
}

int CXISLReturnTag::SetReturnAttribute(LPCTSTR lpszNameList)
{
	CXISLExcItem *pExcItem = (CXISLExcItem*)m_pParentTag->GetParentExcTag();
//	int nCount = ((CXISLDialogTag*)pExcItem->GetParentDialogTag())->GetReCallReturnCount();
	CString strNameList = lpszNameList;

	BOOL bFin = FALSE;
	int nIndex = 0;
	if(!strNameList.IsEmpty())
	{
		while(!bFin)
		{
			CString strVarName;
			nIndex = strNameList.Find(',');
			if(nIndex == -1)
			{
				strVarName = strNameList;
				bFin = TRUE;
			}
			else
				strVarName = strNameList.Left(nIndex);

			CXISLVar *pVar = NULL;
			if(strVarName[0] != '\'')
			{
				pVar = pExcItem->m_pLocalVar->FindVarWithParent(strVarName);
				if(pVar == NULL)
				{
					pVar = new CXISLVar;
					pVar->SetAttribute(strVarName,"",FALSE,FALSE);
					pExcItem->m_pLocalVar->RegistVar(pVar);
				}
				pVar->ReferCount(TRUE);
//				pVar->m_pParent->ReferVar(pVar->GetVarName(),TRUE);
			}
			else
			{
				strVarName.Delete(0);
				strVarName.Delete(strVarName.GetLength()-1);
				pVar = new CXISLVar;
				pVar->SetAttribute(strVarName,"",FALSE,TRUE);
			}
			m_NameList.AddTail(pVar);
			strNameList.Delete(0,nIndex+1);
		}
	}
	return 0;
}

void CXISLReturnTag::GetNameList(CString &strName)
{
	POSITION pos = m_NameList.GetHeadPosition();
	CString strTemp;
	strName.Empty();
	while(pos)
	{
		CXISLVar *pVar = (CXISLVar*)m_NameList.GetNext(pos);
		pVar->GetVarNameEx(strTemp);
		strName += strTemp;
		strName += ",";
	}
	strName.Delete(strName.GetLength()-1);
}

void CXISLReturnTag::InitPtrList()
{
	POSITION oldPos = NULL;
	POSITION pos = m_NameList.GetHeadPosition();
	while(pos)
	{
		oldPos = pos;
		CXISLVar *pVar = (CXISLVar*)m_NameList.GetNext(pos);
		m_NameList.RemoveAt(oldPos);
		if(pVar->IsDummy())
			delete pVar;
	}
}